package lab11.matrix;

import java.util.concurrent.locks.ReentrantReadWriteLock;

import lab11.locks.RWLock;


/** A thread-safe version of the Matrix class that uses reader-writer
 * locks so multiple readers can be working at once. Only modest performance
 * gains are seen on a two-core machine; the payoff should be higher with more cores.
 * 
 * @author Andrew Myers
 */
@SuppressWarnings("unused")
public class RWMatrix extends UnsafeMatrix {

	// Two possible RW lock implementations may be enabled here.
	
	//ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
	RWLock lock = new RWLock();
	
	public RWMatrix(int r, int c) {
		super(r, c);
	}

	@Override
	public double get(int r, int c) {
		lock.readLock().lock();
		try { return fast_get(r, c); }
		finally { lock.readLock().unlock(); }

	}

	@Override
	public void set(int r, int c, double v) {
		lock.writeLock().lock();
		try { fast_set(r, c, v); }
		finally { lock.writeLock().unlock(); }
	}

	@Override
	public void sum() {
		lock.readLock().lock();
		try {
			super.sum();
		} finally {
			lock.readLock().unlock();
		}
	}
	
	@Override
	public void randomize(java.util.Random rnd) {
		lock.writeLock().lock();
		try {
			super.randomize(rnd);
		} finally {
			lock.writeLock().unlock();
		}
	}
	
	@Override
	public void swap(java.util.Random rnd) {
		lock.writeLock().lock();
		try {
			super.swap(rnd);
		} finally {
			lock.writeLock().unlock();
		}
	}
}
