package nomvc;

import javafx.application.Application;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Point2D;
import javafx.scene.Group;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.stage.Stage;

/** This is an implementation of the ButtonCounter application that
 * does not use the MVC design pattern. All the code for the data model
 * and the user interface is here in the ButtonCounter class. This will
 * make it impossible to have multiple views of the same counter.
 * 
 * Can you convert this code to use the MVC design pattern, with a model
 * that has no dependency on JavaFX? Even better, can you make it create
 * two views of the same model?
 * 
 * @author Andrew Myers
 */
public class ButtonCounter extends Application {
	private int count = 0;
	private Label label;
	public static void main(String[] args) {
		launch(args);
	}
	
	@Override
	public void start(Stage s) throws Exception {
		final Pane pane = new HBox();
		s.setOnCloseRequest(null);
		Group g = new Group();
		g.getChildren().add(pane);
		Scene sc = new Scene(g);
		s.setScene(sc);
		s.setWidth(300);
		s.setHeight(300);

		final Button b = new Button("Push me!");
		pane.getChildren().add(b);
		label = new Label("Count: 0");
		pane.getChildren().add(label);
		b.setOnAction(new EventHandler<ActionEvent>() {
            @Override
            public void handle(ActionEvent ae) {
                count++;
                label.setText("Count: " + count);
            }
        });
		
		pane.setOnMouseEntered(new EventHandler<MouseEvent>() {
			@Override
			public void handle(MouseEvent e) {
				b.setDisable(false);
			}
		});
		
		pane.setOnMouseExited(new EventHandler<MouseEvent>() {
			@Override
			public void handle(MouseEvent e) {
				Point2D p = new Point2D(e.getX(), e.getY());
				if (!pane.getLayoutBounds().contains(p)) {
					b.setDisable(true);
				}
			}
		});
		s.show();
		
	}

}