package mvc;

import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.stage.Stage;

/** The controller handles input generated by the user interface and
 *  issues appropriate commands to the model to update its state.
 *  There is more than one way to manage the connection between the
 *  view and the controller; this is just one option.
 */
public class Controller {
	private Counter model;
	public Controller(final Counter model, Stage window1) {
		this.model = model;
		addView(new View(model, window1));
		addView(new View(model, new Stage()));
	}

	public void addView(View view) {
		view.setOnAction(new EventHandler<ActionEvent>() {
            @Override
            public void handle(ActionEvent ae) {
                model.increment();
            }
        });
		view.start();
	}
}
