package sliderDemo;

import javafx.fxml.FXML;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.Label;
import javafx.scene.control.Slider;
import javafx.scene.paint.Color;

/**
 * This is the controller. When the FXML loader loads the FXML file, an instance
 * of this class is created and initialized by running the initialize() method
 * below on the Application thread. This happens automatically.
 */
public class Controller {

   /**
    * These fields refer to View components. They are populated ('injected') by
    * the FXML loader so that they are available during initialization and
    * handler calls. A component can be injected by giving it an fx:id equal to
    * the field name in the FXML file and decorating the field here with @FXML.
    */
   @FXML private Slider redSlider;
   @FXML private Slider greenSlider;
   @FXML private Slider blueSlider;
   @FXML private Label redLabel;
   @FXML private Label greenLabel;
   @FXML private Label blueLabel;
   @FXML private Canvas canvas;
   
   private GraphicsContext gc;
   
   /**
    * This method is run automatically after the scene is loaded.
    */
   @FXML
   public void initialize() {
      gc = canvas.getGraphicsContext2D();
      gc.setFill(Color.BLACK);
      gc.fillRect(0, 0, canvas.getWidth(), canvas.getHeight());
      
      // set property listeners
      redSlider.valueProperty().addListener(
         (obs, oldValue, newValue) -> update(redLabel, newValue.intValue()));
      greenSlider.valueProperty().addListener(
         (obs, oldValue, newValue) -> update(greenLabel, newValue.intValue()));
      blueSlider.valueProperty().addListener(
         (obs, oldValue, newValue) -> update(blueLabel, newValue.intValue())); 
   }
   
   // react to slider change - set new color
   void update(Label label, int value) {
      label.setText(String.format("%d", value));
      int red = redSlider.valueProperty().intValue();
      int green = greenSlider.valueProperty().intValue();
      int blue = blueSlider.valueProperty().intValue();
      gc.setFill(Color.rgb(red, green, blue));
      gc.fillRect(0, 0, canvas.getWidth(), canvas.getHeight());
   }

}
