package silly;

import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Application;
//import javafx.beans.property.DoubleProperty;
//import javafx.beans.value.ChangeListener;
//import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Orientation;
import javafx.scene.*;
import javafx.scene.control.*;
//import javafx.scene.effect.DropShadow;
import javafx.scene.layout.*;
import javafx.scene.paint.Color;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.Shape;
import javafx.stage.*;
import javafx.util.Duration;

public class Main extends Application {
	public static void main(String[] args) {
		Application.launch(args);
	}

	static final int SIZE = 400;
	@Override
	public void start(Stage s) throws Exception {
		HBox root = new HBox();
		Scene scene = new Scene(root);
		s.setScene(scene);
		VBox lhs = new VBox();
		HBox buttons = new HBox();
	
		root.getChildren().add(lhs);
		Button b1, b2;
		lhs.getChildren().addAll(new TextArea(), buttons);
		buttons.getChildren().addAll(b1 = new Button("press me"),
				new Separator(Orientation.HORIZONTAL),
				b2 = new Button("click me"));
		Pane pane = new Pane();
		root.getChildren().add(pane);
		pane.setPrefWidth(SIZE);
		pane.setPrefHeight(SIZE);
		pane.setStyle("-fx-background-color: #cfc");
		
		final Group g = new Group();
		int j = 40;
		for (int i = 0; i < 4; i++, j/=2) {
			Shape square = new Rectangle(j,j);
			square.setFill(new Color(1, i/3., i/3., 1.0));
			g.getChildren().add(square);
		}
		//square.setStyle("-fx-background-color: red");
		pane.getChildren().add(g);
		
		b1.setOnAction(new EventHandler<ActionEvent>(){
			@Override
			public void handle(ActionEvent e) {		
				g.setLayoutX(g.getLayoutX() + 20);
				
			}});
		b2.setOnAction(new EventHandler<ActionEvent>() {
			@Override
			public void handle(ActionEvent arg0) {
				Timeline t = new Timeline();
				t.getKeyFrames().addAll(
						new KeyFrame(Duration.seconds(1),
								new KeyValue(g.layoutXProperty(), SIZE - 20),
								new KeyValue(g.layoutYProperty(), SIZE/2)),
						new KeyFrame(Duration.seconds(2),
								new KeyValue(g.layoutXProperty(), 0),
								new KeyValue(g.layoutYProperty(), 0))
						);
				t.play();
			}});
		
		s.sizeToScene();
		s.show();
	}
}
