package mvcDemo;

import java.util.Random;

import javafx.beans.property.SimpleStringProperty;

/**
 * This is the model. It contains data relevant to the current
 * state of the application.
 */
public class Model {

   private final int N = Controller.N;
   private boolean running = false;
   private int x = 0, y = 0;
   private Direction direction = Direction.EAST;
   private int score = 0;
   private int trials = 0;
   // An observable property. During initialization, the controller
   // registers a ChangeListener on this property. When the string changes,
   // an event is fired and is handled by the listener.
   SimpleStringProperty rating = new SimpleStringProperty("");

   // These methods are only ever called on the Application thread
   // and do not need to be synchronized.
   
   boolean isRunning() {
      return running;
   }

   void setRunning(boolean r) {
      running = r;      
   }
   
   int getX() {
      return x;
   }

   int getY() {
      return y;
   }
   
   // These two methods must be synchronized because they access
   // shared data (the direction field).
   // This method is called on the Application thread.
   synchronized void advance() {
      x = (x + direction.dx + N) % N;
      y = (y + direction.dy + N) % N;
   }

   // This method called on the Animation thread.
   synchronized void setRandomDirection() {
      final Random rand = new Random();
      direction = Direction.values()[rand.nextInt(8)];
   }

   void updateScore(boolean successful) {
      trials++;
      if (successful) score++;
      rating.set(getRating(score, trials));
   }

   String getScore() {
      return String.format("%d/%d", score, trials);
   }
   
   private String getRating(int score, int trials) {
      final double[] levels = { .2, .33, .5, .67, .75, .9, 1.0 };
      final String[] rating = {
         "pathetic", "sad", "meh", "ok", "better", "great", "amazing", "perfect" };
      double l = (double)score/trials;
      int i;
      for (i = 0; i < levels.length && l >= levels[i]; i++);
      return rating[i];
   }

}

enum Direction {
   NORTH (0,-1), NORTHEAST (1,-1), EAST (1,0), SOUTHEAST (1,1),
   SOUTH (0,1), SOUTHWEST (-1,1), WEST (-1,0), NORTHWEST (-1,-1);
   final int dx;
   final int dy;
   
   Direction(int dx, int dy) {
       this.dx = dx;
       this.dy = dy;
   }
}
