package liveDemo;

import java.io.IOException;
import java.net.URL;
import java.util.ResourceBundle;

import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Application;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.stage.Stage;
import javafx.util.Duration;

public class Main extends Application implements Initializable {
	@FXML
	private Button b;
	@FXML
	private Button c;
	@FXML
	private Label t;
	
	public static void main(String[] args) {
		Application.launch(args);
	}
	
	@Override
	public void start(final Stage stage) {
		try {
			final URL r = getClass().getResource("main.fxml");
			if (r == null) {
				System.out.println("No FXML resource found.");
				try {
					stop();
				} catch (final Exception e) {}
				return;
			}
			final Parent node = FXMLLoader.load(r);
			final Scene scene = new Scene(node);
			stage.setTitle("Lab 9 Demo");
			stage.setScene(scene);
			stage.sizeToScene();
			stage.show();
		} catch (final IOException ioe) {
			System.out.println("Can't load FXML file.");
			ioe.printStackTrace();
			try {
				stop();
			} catch (final Exception e) {}
		}

	}
	
	
	@FXML
	private void handleButtonPressed(final ActionEvent ae) {
		System.out.println("Button 1 was pressed");
		t.setText("Hello World");
	}
	
	
	@FXML
	private void handleButtonPressed2(final ActionEvent ae) {
		System.out.println("Button 2 was pressed");
		Timeline tl = new Timeline();
		tl.getKeyFrames().add(new KeyFrame(Duration.millis(500), "move",
				new KeyValue(c.layoutYProperty(), c.getLayoutY() + 100.0)));
		tl.play();
		t.setText("YOU CLICKED THE WRONG BUTTON");
	}

	

	@Override
	public void initialize(URL location, ResourceBundle resources) {
		
	}

}
