package grid;

import javafx.event.EventHandler;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.input.MouseEvent;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

/**
 * This is an example of rendering using a JavaFX Canvas to draw graphics
 * directly.
 */
public class Grid extends Canvas {
   public static final int SIZE = 10;
   private static Color[] rainbow = { Color.RED, Color.ORANGE, Color.YELLOW,
            Color.GREEN, Color.BLUE, Color.MAGENTA };
   private int colorCounter = 0;
   int selx, sely;
   Main main;
   Paint bkg = Color.BLACK;

   public Grid(Main main) {
      selx = sely = 0;
      setWidth(600);
      setHeight(600);
      this.main = main;

      setupEventHandlers();
   }

   private void setupEventHandlers() {
      setOnMouseMoved(new EventHandler<MouseEvent>() {
         @Override
         public void handle(MouseEvent e) {
            double x = e.getX() * SIZE / getWidth();
            double y = e.getY() * SIZE / getHeight();
            main.reportLocation(x, y);
         }
      });
      setOnMousePressed(new EventHandler<MouseEvent>() {
         @Override
         public void handle(MouseEvent e) {

            double x = e.getX() * SIZE / getWidth();
            double y = e.getY() * SIZE / getHeight();
            System.out.println("Saw click at " + x + " " + y);
            System.out.println("looking for " + selx + " " + sely);
            if (selx == (int)x && sely == (int)y) {
               System.out.println("DING");
               bkg = rainbow[colorCounter];
               draw();
               colorCounter++;
               if (colorCounter >= rainbow.length) {
                  colorCounter = 0;
               }
            }
         }
      });
   }

   public void draw() {
      GraphicsContext g = getGraphicsContext2D();
      g.setFill(bkg);

      g.fillRect(0, 0, getWidth(), getHeight());

      g.setFill(rainbow[(selx + sely * SIZE) % rainbow.length]);
      g.fillRect(selx * getWidth() / SIZE, sely * getHeight() / SIZE,
               getWidth() / SIZE, getHeight() / SIZE);

      g.setStroke(Color.WHITE);
      for (int i = 1; i <= 9; i++) {
         g.strokeLine(0, getHeight() * i / SIZE, getWidth(),
                  getHeight() * i / SIZE);
         g.strokeLine(getWidth() * i / SIZE, 0, getWidth() * i / SIZE,
                  getHeight());
      }
   }

   public void advanceSelection() {
      selx++;
      if (selx >= SIZE) {
         selx = 0;
         sely++;
         if (sely >= SIZE) sely = 0;
      }
      draw();
   }
}
