package fxml;

import java.io.IOException;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Application;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.TextArea;
import javafx.stage.Stage;
import javafx.util.Duration;

// a small example of reading a scene layout from an XML file instead of
// creating all the objects.
public class Main extends Application implements Initializable {
	@FXML
	private Button b;
	@FXML
	private Button c;
	@FXML
	private TextArea t;
	String message = "Button was clicked";

	public static void main(final String[] args) {
		Application.launch(args);
	}

	@Override
	public void start(final Stage stage) {
		try {
			final URL r = getClass().getResource("simple.fxml");
			if (r == null) {
				System.out.println("No FXML resource found.");
				try {
					stop();
				} catch (final Exception e) {}
				return;
			}
			final Parent node = FXMLLoader.load(r);
			final Scene scene = new Scene(node);
			stage.setTitle("FXML demo");
			stage.setScene(scene);
			stage.sizeToScene();
			stage.show();

		} catch (final IOException ioe) {
			System.out.println("Can't load FXML file.");
			ioe.printStackTrace();
			try {
				stop();
			} catch (final Exception e) {}
		}

	}

	@FXML
	private void handleButtonPressed(final ActionEvent ae) {
		System.out.println(message);
		Timeline tl = new Timeline();
		tl.getKeyFrames().add(new KeyFrame(Duration.millis(500), "move",
				new KeyValue(b.layoutYProperty(), b.getLayoutY() + 100.0)));
		tl.play();
	}

	@FXML
	private void handleButtonPressed2(final ActionEvent ae) {
		System.out.println(message);
		Timeline tl = new Timeline();
		tl.getKeyFrames().add(new KeyFrame(Duration.millis(500), "move",
				new KeyValue(c.layoutYProperty(), c.getLayoutY() + 100.0)));
		tl.play();
	}

	@Override
	public void initialize(final URL location, final ResourceBundle resources) {
		t.textProperty().addListener(new ChangeListener<String>() {
			@Override
			public void changed(final ObservableValue<? extends String> obs,
					final String before, final String after) {
				System.out.println(
						"Changed from \"" + before + "\" to \"" + after + "\"");
			}
		});
	}
}
