package complex;

import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Application;
import javafx.beans.property.DoubleProperty;
//import javafx.beans.value.ChangeListener;
//import javafx.beans.value.ObservableValue;
//import javafx.event.ActionEvent;
//import javafx.event.EventHandler;
import javafx.geometry.Orientation;
import javafx.scene.*;
import javafx.scene.control.*;
import javafx.scene.effect.DropShadow;
import javafx.scene.layout.*;
import javafx.scene.paint.Color;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.Shape;
import javafx.stage.*;
import javafx.util.Duration;

public class Main extends Application {
	static final int SIZE = 400;

	@Override
	public void start(Stage s) throws Exception {
		HBox root = new HBox();
		Scene scene = new Scene(root);
		s.setScene(scene);
		VBox lhs = new VBox();
		HBox buttons = new HBox();
		lhs.setStyle("-fx-background-color: #666");
		final TextField tf = new TextField();
		lhs.getChildren().addAll(tf, new Separator(Orientation.VERTICAL), buttons);

		Button b1, b2;
		buttons.getChildren().addAll(
				b1 = new Button("press me"),
				new Separator(Orientation.HORIZONTAL),
				b2 = new Button("click me"));
				
		root.getChildren().add(lhs);
		final Pane pane = new Pane();
		pane.setStyle("-fx-background-color: #88a");
		final Group square = new Group();
		for (int i = 0, j = 40; i < 4; i++, j /= 2) {
			Rectangle r = new Rectangle(j, j);
			r.setFill(new Color(1., i/3.0, i/3.0, 1.0));
			square.getChildren().add(r);
//			r.layoutXProperty().bind(square.layoutXProperty().divide(i));
		}

		ScrollBar sb = new ScrollBar();
		sb.minProperty().setValue(0);
		sb.maxProperty().setValue(1);
		//sb.valueProperty().bind(square.layoutYProperty());
		sb.orientationProperty().set(Orientation.VERTICAL);
		
		final Node funky = fractal(SIZE/3, sb.valueProperty());
		funky.setLayoutX(SIZE/2);
		funky.setLayoutY(SIZE/2);

		pane.getChildren().addAll(square, funky);

		root.getChildren().addAll(pane, sb);

		pane.setPrefWidth(SIZE);
		pane.setPrefHeight(SIZE);
		
		scene.setRoot(root);
		s.show();
		
		b1.setOnAction(e -> System.out.println("pressed " + tf.getText()));

		sb.valueProperty().addListener(
			(arg0, arg1, arg2) ->
				pane.setPrefWidth(SIZE* (1 - arg2.doubleValue())));
//		sb.valueProperty().addListener((arg0, arg1, arg2) ->
//				pane.setPrefWidth(SIZE* (1 - arg2.doubleValue())));

		b2.setOnAction(e -> {
				Timeline timeline = new Timeline();
				timeline.getKeyFrames().addAll(
						new KeyFrame(Duration.seconds(1),
                                new KeyValue(square.layoutXProperty(), SIZE-20),
								new KeyValue(square.layoutYProperty(), SIZE/2)),
						new KeyFrame(Duration.seconds(2),
                                new KeyValue(square.layoutXProperty(), 0),
								new KeyValue(square.layoutYProperty(), SIZE-40)),
						new KeyFrame(Duration.seconds(2.5),
                                new KeyValue(square.layoutXProperty(), 0),
								new KeyValue(square.layoutYProperty(), 0)));
				timeline.play();
			});
	}
	private Node fractal(int i, DoubleProperty obs) {
		Group g = new Group();
		Shape center = new Rectangle(i/3, i/3);
		center.setLayoutX(i/3);
		center.setLayoutY(i/3);
		center.setFill(Color.WHITE);
		center.setStroke(Color.BLACK);
		center.setEffect(new DropShadow());
		g.getChildren().add(center);
		if (i > 2)
		for (int j = 0; j < 9; j++) {
			if (j == 4) continue;
			Node ch = fractal(i/3, obs);
			ch.layoutXProperty().bind(obs.negate().add(1).multiply(i*(j%3)/3));
			ch.layoutYProperty().bind(obs.negate().add(1).multiply(i*(j/3)/3));
			g.getChildren().add(ch);
		}
		
		return g;
	}
	public static void main(String[] args) {
		Application.launch(args);
	}
}
