package easyIO;

/** A Recognizer that decides what other recognizer to use based on the lookahead character.
 */
public abstract class PredictiveRecognizer implements Recognizer {
	/** Provide another recognizer to use based on the next character in the input.
	 *  Subclasses are expected to override this to provide the correct prediction. */
	abstract Recognizer predict(int c);
	
	public void recognize(BacktrackScanner s, Continuation cont) throws Success {
		Recognizer r = predict(s.peek());
		r.recognize(s, cont);
	}
}
