package cs2110.test;

import static org.junit.Assert.*;

import org.junit.Test;

import cs2110.AdjustablePriorityQueue;
import cs2110.FIFO;
import cs2110.LIFO;
import cs2110.RandomQueue;

public class QueueTest {
   
   private int[] testArray = { 1, 4, 2, 6, 7, 9, 3, 5, 8, 0 };

   @Test
   public void adjustablePriorityQueueTest() {
      AdjustablePriorityQueue<Integer> q = new AdjustablePriorityQueue<Integer>();
      assertEquals(0, q.size());
      assertTrue(q.isEmpty());
      
      for (int i = 0; i < testArray.length; i++) {
         q.add(testArray[i]);
      }
      assertEquals(testArray.length, q.size());
      assertFalse(q.isEmpty());
      
      for (Integer i : q) {
         assertEquals(Double.POSITIVE_INFINITY, q.getPriority(i), 0);
         q.setPriority(i, i);
      }
      for (Integer i : q) {
         assertEquals(i, q.getPriority(i), 0);
      }
      while (!q.isEmpty()) {
         int s = q.size();
         int i = q.peek();
         assertEquals(i, q.getPriority(i), 0);
         i = q.poll();
         assertEquals(s - 1, q.size());
      }
   }
   
   @Test
   public void randomQueueTest() {
      RandomQueue<Integer> q = new RandomQueue<Integer>();
      assertEquals(0, q.size());
      assertTrue(q.isEmpty());
      
      for (int i = 0; i < testArray.length; i++) {
         q.add(testArray[i]);
      }
      assertEquals(testArray.length, q.size());
      assertFalse(q.isEmpty());
      
      for (int i = 0; i < testArray.length; i++) {
         int s = q.size();
         int e = q.peek();
         assertTrue(q.contains(e));
         e = q.poll();
         assertFalse(q.contains(e));
         assertEquals(s - 1, q.size());
      }
      assertNull(q.peek());
      assertNull(q.poll());
      assertTrue(q.isEmpty());
      assertEquals(0, q.size());
   }

   @Test
   public void fifoTest() {
      FIFO<Integer> q = new FIFO<Integer>();
      assertEquals(0, q.size());
      assertTrue(q.isEmpty());
      
      for (int i = 0; i < testArray.length; i++) {
         q.add(testArray[i]);
      }
      assertEquals(testArray.length, q.size());
      assertFalse(q.isEmpty());
      
      for (int i = 0; i < testArray.length; i++) {
         int s = q.size();
         int e = q.peek();
         assertTrue(q.contains(e));
         e = q.poll();
         assertFalse(q.contains(e));
         assertEquals(testArray[i], e);
         assertEquals(s - 1, q.size());
      }
      assertNull(q.peek());
      assertNull(q.poll());
      assertTrue(q.isEmpty());
      assertEquals(0, q.size());
   }
   
   @Test
   public void lifoTest() {
      LIFO<Integer> q = new LIFO<Integer>();
      assertEquals(0, q.size());
      assertTrue(q.isEmpty());
      
      for (int i = 0; i < testArray.length; i++) {
         q.add(testArray[i]);
      }
      assertEquals(testArray.length, q.size());
      assertFalse(q.isEmpty());
      
      for (int i = 0; i < testArray.length; i++) {
         int s = q.size();
         int e = q.peek();
         assertTrue(q.contains(e));
         e = q.poll();
         assertFalse(q.contains(e));
         assertEquals(testArray[testArray.length - i - 1], e);
         assertEquals(s - 1, q.size());
      }
      assertNull(q.peek());
      assertNull(q.poll());
      assertTrue(q.isEmpty());
      assertEquals(0, q.size());
   }

}
