package cs2110;

import java.util.AbstractQueue;
import java.util.Iterator;
import java.util.PriorityQueue;
import java.util.Random;

/**
 * An implementation of the java.util.Queue interface in which elements are
 * extracted in a random order.
 * 
 * @param <T>
 *           the type of elements contained in this {@code RandomQueue}.
 */
public class RandomQueue<T> extends AbstractQueue<T> {

   private PriorityQueue<Ordered<T>> pq = new PriorityQueue<Ordered<T>>();
   private Random rand = new Random();

   private class Ordered<S> implements Comparable<Ordered<S>> {
      private S item;
      private int priority;

      private Ordered(S item) {
         this.item = item;
         priority = rand.nextInt();
      }

      public int compareTo(Ordered<S> obj) {
         return obj.priority - priority;
      }
   }

   /**
    * {@inheritDoc}
    * See {@link java.util.Queue#offer(Object)}.
    */
   @Override
   public boolean offer(T e) {
      return pq.offer(new Ordered<T>(e));
   }

   /**
    * {@inheritDoc}
    * See {@link java.util.Queue#peek()}.
    */
   @Override
   public T peek() {
      Ordered<T> x = pq.peek();
      if (x == null) return null;
      return x.item;
   }

   /**
    * {@inheritDoc}
    * See {@link java.util.Queue#poll()}.
    */
   @Override
   public T poll() {
      Ordered<T> x = pq.poll();
      if (x == null) return null;
      return x.item;
   }

   /**
    * {@inheritDoc}
    * See {@link java.util.Collection#size()}.
    */
   @Override
   public int size() {
      return pq.size();
   }

   /**
    * {@inheritDoc}
    * See {@link java.util.Collection#iterator()}.
    */
   @Override
   public Iterator<T> iterator() {
      return new RandomQueueIterator(pq.iterator());
   }

   private class RandomQueueIterator implements Iterator<T> {

      private Iterator<Ordered<T>> iterator;

      private RandomQueueIterator(Iterator<Ordered<T>> iterator) {
         this.iterator = iterator;
      }

      @Override
      public boolean hasNext() {
         return iterator.hasNext();
      }

      @Override
      public T next() {
         return iterator.next().item;
      }

      @Override
      public void remove() {
         iterator.remove();
      }

   }
}
