package cs2110;

import java.util.AbstractQueue;
import java.util.Iterator;
import java.util.Stack;

/**
 * A LIFO implementation of the {@link java.util.Queue} interface, i.e. a stack.
 * 
 * @param <T>
 *           The type of objects contained in this LIFO.
 */
public class LIFO<T> extends AbstractQueue<T> {

   private Stack<T> stack = new Stack<T>();

   /**
    * {@inheritDoc}
    * See {@link java.util.Queue#offer(Object)}.
    */
   @Override
   public boolean offer(T e) {
      stack.push(e);
      return true;
   }

   /**
    * {@inheritDoc}
    * See {@link java.util.Queue#peek()}.
    */
   @Override
   public T peek() {
      if (size() == 0) return null;
      return stack.peek();
   }

   /**
    * {@inheritDoc}
    * See {@link java.util.Queue#poll()}.
    */
   @Override
   public T poll() {
      if (size() == 0) return null;
      return stack.pop();
   }

   /**
    * {@inheritDoc}
    * See {@link java.util.Collection#iterator()}.
    */
   @Override
   public Iterator<T> iterator() {
      return stack.iterator();
   }

   /**
    * {@inheritDoc}
    * See {@link java.util.Collection#size()}.
    */
   @Override
   public int size() {
      return stack.size();
   }

}
