package cs2110;

import java.io.BufferedReader;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;

/**
 * Runs an external script that takes a string on stdin and writes a string to
 * stdout. Example of use: Suppose <code>xxxyyy.pl</code> is a perl script in
 * the user's working directory that contains
 * 
 * <pre>
 * #!perl
 * $_ = &lt;STDIN&gt;;
 * chomp();
 * printf "xxx %s yyy\n", $_;
 * __END__
 * </pre>
 * 
 * Then the Java call
 * 
 * <pre>
 * Filter f = new Filter(&quot;perl xxxyyy.pl&quot;);
 * System.out.println(f.filter(&quot;hello world&quot;));
 * </pre>
 * 
 * will output
 * 
 * <pre>
 * xxx hello world yyy
 * </pre>
 */
public class Filter {

   private String[] cmd;

   /**
    * Construct a filter for a given external script.
    * 
    * @param cmd
    *           the command used to invoke the script.
    */
   public Filter(String cmd) {
      this.cmd = cmd.trim().split("[ ]+");
   }

   /**
    * Runs an external script on an input string and returns the output string
    * produced by the script.
    * 
    * @param input
    *           the input string to be processed by the script
    * @return the output string produced by the script
    * @throws IOException
    *           if an I/O error occurs
    * @throws InterruptedException
    *           if the process is interrupted by another thread
    */
   public String filter(String input) throws IOException,
            InterruptedException {
      Process process = Runtime.getRuntime().exec(cmd);
      BufferedWriter out = new BufferedWriter(new OutputStreamWriter(process.getOutputStream()));
      out.write(input);
      out.close();
      process.waitFor();
      if (process.exitValue() != 0) throw new IOException();
      StringBuilder sb = new StringBuilder();
      BufferedReader in = new BufferedReader(new InputStreamReader(process.getInputStream()));
      for (String line = in.readLine(); line != null; line = in.readLine()) {
         sb.append(line);
         sb.append("\n");
      }
      return sb.toString();
   }

}
