package cs2110;

import java.util.AbstractQueue;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/**
 * A FIFO implementation of the {@link java.util.Queue} interface.
 * 
 * @param <T>
 *           The type of objects contained in this FIFO.
 */
public class FIFO<T> extends AbstractQueue<T> {
   
   private List<T> list = new LinkedList<T>();

   /**
    * {@inheritDoc}
    * See {@link java.util.Queue#offer(Object)}.
    */
   @Override
   public boolean offer(T e) {
      list.add(e);
      return true;
   }

   /**
    * {@inheritDoc}
    * See {@link java.util.Queue#peek()}.
    */
   @Override
   public T peek() {
      if (size() == 0) return null;
      return list.get(0);
   }

   /**
    * {@inheritDoc}
    * See {@link java.util.Queue#poll()}.
    */
   @Override
   public T poll() {
      if (size() == 0) return null;
      return list.remove(0);
   }

   /**
    * {@inheritDoc}
    * See {@link java.util.Collection#iterator()}.
    */
   @Override
   public Iterator<T> iterator() {
      return list.iterator();
   }

   /**
    * {@inheritDoc}
    * See {@link java.util.Collection#size()}.
    */
   @Override
   public int size() {
      return list.size();
   }

}
