package demoServlet;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;

import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * Servlet implementation class
 */
@WebServlet("/") /* relative URL path to servlet (under package name 'demoServlet'). */
public class Servlet extends HttpServlet {
	private static final long serialVersionUID = 1L;
	
	private String message = "Hello world!";

	/**
	 * Handle GET request
	 */
	protected void doGet(HttpServletRequest request, HttpServletResponse response)
			throws ServletException, IOException {
		response.addHeader("Content-Type", "text/plain");
		PrintWriter w = response.getWriter();
		
		w.println("GET URI = " + request.getRequestURI());
		w.println("Message: " + message);
	}

	/**
	 * Handle POST request.
	 */
	protected void doPost(HttpServletRequest request, HttpServletResponse response)
			throws ServletException, IOException {
		response.addHeader("Content-Type", "text/plain");
		BufferedReader r = request.getReader();
		message = r.readLine();
		PrintWriter w = response.getWriter();
		w.append("POST URI = " + request.getRequestURI() + "\r\n");
		w.println("Changed message to " + message);
	}

}
