package eventgen;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;

/** A simple and straightforward implementation of EventGenerator. */
public class SimpleGenerator<Variable> implements EventGenerator<Variable> {
	Map<Variable, Double> events = new HashMap<Variable, Double>();
	Random rnd = new java.util.Random();

	public void removeVariable(Variable e) {
		events.remove(e);
	}

	public void addVariable(Variable e, double p) {
		events.put(e, p);
	}

	public void setProbability(Variable e, double p) {
		events.put(e, p);
	}
	
	public boolean contains(Variable e) {
		return events.containsKey(e);
	}

	public Collection<Variable> sample() {
		Collection<Variable> ret = new HashSet<Variable>();
		for (Map.Entry<Variable, Double> ep : events.entrySet()) {
			Variable e = ep.getKey();
			double p = ep.getValue();
			if (rnd.nextDouble() < p) {
				ret.add(e);
			}
		}
		return ret;
	}
	
	public Collection<Variable> sample(double t) {
		Collection<Variable> ret = new HashSet<Variable>();
		for (Map.Entry<Variable, Double> ep : events.entrySet()) {
			Variable e = ep.getKey();
			double p = ep.getValue();
			double p2 = (t == 1.0) ? p : 1.0 - Math.pow(1.0 - p, t);
			if (rnd.nextDouble() < p2) {
				ret.add(e);
			}
		}
		return ret;
	}
}
