import static org.junit.Assert.*;

import org.junit.Test;


public class DemoTester {

    @Test
    public void testMiddle() {
        //assertEquals(expected val, computed val);
        assertEquals(1, Demo.middle(1, 2, -3)); // b is the middle
        assertEquals(1, Demo.middle(1, -3, 2)); 
        assertEquals(1, Demo.middle(2, 1, -3)); // c is the middle
        assertEquals(1, Demo.middle(-3, 1, 2)); 
        assertEquals(1, Demo.middle(-3, 2, 1)); // d is the middle
        assertEquals(1, Demo.middle(-3, 2, 1));
    }
    

    @Test
    // Note that this doesn't really test procedure printMiddle.
    //You have to eyeball the output to see whether it is correct.
    // This is because procedure printMiddle does not return a result.
    public void testPrintMiddle() {
        //assertEquals(expected val, computed val);
        Demo.printMiddle(1, 2, 3);
        Demo.printMiddle(5, 2, -3);
    }
    
    @Test
    public void testFormTriangle() {
        // Note that we have not test "corner cases",
        // like b+c = d
        //assertEquals(expected val, computed val);
        assertEquals(false, Demo.formTriangle(0, 1, 2)); 
        assertEquals(false, Demo.formTriangle(1, -3, 2)); 
        assertEquals(false, Demo.formTriangle(2, 1, -3)); 
        
        assertEquals(true, Demo.formTriangle(1, 1, 1)); 
        assertEquals(false, Demo.formTriangle(5, 2, 1));
        assertEquals(false, Demo.formTriangle(1, 5, 2));
        assertEquals(false, Demo.formTriangle(1, 2, 5));
    }
    
    @Test
    public void testComesBefore() {

        //assertEquals(expected val, computed val);
        assertEquals(false, Demo.comesBefore(2015, 2, 3, 2015, 2, 3));
        
        assertEquals(true,  Demo.comesBefore(2012, 2, 3, 2015, 2, 3)); 
        assertEquals(true, Demo.comesBefore(2015, 1, 3, 2015, 2, 3));  
        assertEquals(true, Demo.comesBefore(2015, 2, 3, 2015, 2, 4));
        
        assertEquals(false, Demo.comesBefore(2016, 2, 3, 2015, 2, 4)); 
        assertEquals(false, Demo.comesBefore(2015, 5, 3, 2015, 2, 4));
        assertEquals(false, Demo.comesBefore(2015, 5, 3, 2015, 2, 2));  
    }
    
    // Note. We haven't given test cases for functions mb, m, transform

}
