/**
 * Represents an employee record. Contains data/methods common to all employees,
 * such as salary. Abstract because we shouldn't be able to create a generic
 * employee, without specifying what sort of role the employee plays in the
 * organization.
 */
public abstract class Employee {

	private double salary;  // Salary of the employee

	/** Construct with salary s. */
	public Employee(double s) {
		salary= s;
	}

	/** Set the salary to s. */
	public void setSalary(double s) {
		salary = s;
	}

    /** Get the salary of the employee. */
	public double getSalary() {
		return salary;
	}

	/**
	 * Introduce oneself, identifying one's role. This is an abstract method
	 * because each type of employee will introduce him/herself in a different
	 * way. A generic employee has no role-specific introduction, so this is an
	 * abstract method which must be implemented in subclasses.
	 */
	public abstract void hello();
}
