/** This class contains static methods used to anglicize integers
 * in the range 1..999,999.
 * To "anglicize" means to put into English.
 * Method anglicize contains the solution. 
 * The important point is not the final product but the method of
 * its development, starting with the smaller numbers (as shown below
 * in method anglicize) and interspersing coding with testing. Function
 * smallWord was created at an opportune moment, so as not to complicate
 * the main program and make it too long..
 * Recursion arises naturally in attempting to anglicize
 * integers greater than 100. */

public class Ang {
    public final static String[] ang19= {"", "one", "two", "three", "four", "five",
            "six", "seven", "eight", "nine", "ten", "eleven", "twelve",
            "thirteen", "fourteen", "fifteen", "sixteen", "seventeen",
            "eighteen", "nineteen"};
    public final static String[] tenWords= {"", "", "twenty", "thirty", "forty",
        "fifty", "sixty", "seventy", "eighty", "ninety"};
    
    /** = English equivalent of n.
    Precondition: 0 < n < 1,000,000.
    Examples:
    3:      "three"
    45:     "forty five"
    100:    "one hundred"
    127:    "one hundred twenty seven"
    1001:   "one thousand one"
    999099: "nine hundred ninety thousand ninety nine*/
    public static String anglicize(int n) {
        if (n <= 19) {
            return smallWord(n);
        }
        
        // 20 <= n
        if (n < 100) {
            return tenWords[n/10] + (n%10 == 0 ? "" : " " + smallWord(n%10));
        }
        
        // 100 <= n
        if (n < 1000) {
            return smallWord(n/100) + " hundred" + 
        (n%100 == 0 ? "" : " " + anglicize(n%100));
        }
        
        // 1000 <= n
        return anglicize(n/1000) + " thousand" +
             (n%1000 == 0 ? "" : " " + anglicize(n%1000));
    }


    /** Return the word for n.
     * Precondition: n in 1..19 */
    public static String smallWord(int n) {
        assert 0 < n  && n <= 19;
        return ang19[n];
    }
}




