package cs2110;

/**
 * An immutable class representing a point in the 2D coordinate plane with `double` coordinates.
 */
public class Point {

    /**
     * The x-coordinate of this point.
     */
    private final double x;

    /**
     * The y-coordinate of this point.
     */
    private final double y;

    /**
     * Constructs a `Point` object with the given `x`- and `y`-coordinates.
     */
    public Point(double x, double y) {
        this.x = x;
        this.y = y;
    }

    /**
     * Returns the x-coordinate of this point.
     */
    public double x() {
        return x;
    }

    /**
     * Returns the y-coordinate of this point.
     */
    public double y() {
        return y;
    }

    /**
     * Returns the distance between this point and the given `other` point.
     */
    public double distanceTo(Point other) {
        return Math.sqrt(Math.pow(this.x - other.x, 2) + Math.pow(this.y - other.y, 2));
    }

    /**
     * Reflects this point over the line y = `m`x + `b` for the given slope `m` and y-intercept
     * `b` and returns a new Point with these reflected coordinates.
     */
    public Point reflectOver(double m, double b) {
        /* Note: this pattern of "return a new transformed object" is common in immutable classes.
         * We give the client the option to reassign their variable to the transformed object.
         */
        double newx = this.x - 2 * b * m + 2 * m * this.y - this.x * m * m;
        double newy = 2 * this.x * m + 2 * b + m * m * this.y - this.y;
        double d = 1 + m * m;
        return new Point(newx / d, newy / d);
    }

    /** Returns a String representation of this Point, of the form "Point (x,y)". */
    @Override
    public String toString() {
        return "Point (" + this.x + "," + this.y + ")";
    }

    /** Returns whether this Point is equal to another `obj`. This will be true if `obj` is a
     * Point with the same coordinates. */
    @Override
    public boolean equals(Object obj) {
        if ((obj == null) || (this.getClass() != obj.getClass())) {
            return false;
        }

        Point other = (Point) obj;
        return (this.x == other.x) && (this.y == other.y);
    }

    public static void main(String[] args) {
        Point p1 = new Point(0.0, 3.0);
        Point p2 = new Point(4.0, 1.0);
        Point p3 = p1.reflectOver(2.0, -2.0);
        System.out.println("p2: " + p2);
        System.out.println("p3: " + p3);
        System.out.println("==: " + (p2 == p3)); // we don't have equality of reference
        System.out.println("equals(): " + p2.equals(p3)); // we do have equality of state
    }
}