package cs2110;

import java.util.Arrays;

/**
 * Demonstrates throwing and checking a checked exception.
 */
public class ExceptionDemo2 {

    /**
     * Returns an index `i` with `0 < i < a.length-1` that corresponds to a local maximum of array
     * `a`, meaning `a[i] > a[i-1]` and `a[i] > a[i+1]`. Throws a `NoLocalMaxException` if `a` does
     * not contain a local max.
     */
    static int findLocalMax(int[] a) throws NoLocalMaxException {
        /* loop invariant: `a[1..i)` are not local maxima. */
        for (int i = 1; i < a.length - 1; i++) {
            if (a[i] > a[i - 1] && a[i] > a[i + 1]) {
                return i;
            }
        }
        // loop exited, no local max found
        throw new NoLocalMaxException();
    }

    /**
     * Decreases the value of a local maximum of array `a` by 1, or does nothing if `a` does not
     * contain a local maximum.
     */
    public static void reduceMax(int[] a) {
        try {
            int maxLoc = findLocalMax(a);
            a[maxLoc]--;
        } catch (NoLocalMaxException ignored) {
            // do nothing
        }
    }

    public static void main(String[] args) {
        int[] a = {3, 2, 1};
        reduceMax(a);
        System.out.print(Arrays.toString(a));
    }
}
