package cs2110;

/**
 * Models an open interval with integer endpoints.
 */
public class Interval {

    /**
     * The left endpoint (exclusive) of the interval.
     */
    private int left;

    /**
     * The right endpoint (exclusive) of the interval.
     */
    private int right;

    /**
     * Constructs a new open interval with the given endpoints.
     */
    public Interval(int left, int right) {
        this.left = left; // use `this` to access field
        this.right = right;
    }

    /**
     * Translates this interval to the right by the given `shift` amount.
     */
    public void translate(int shift) {
        this.left += shift; // we could omit `this` here
        this.right += shift;
    }

    @Override // from the Object class
    public String toString() {
        return "(" + this.left + "," + this.right + ")";
    }

    public static void main(String[] args) {
        Interval a = new Interval(1,5);
        Interval b = a;
        b.translate(3);
        b = new Interval(2,4);
        System.out.println("a: " + a.toString());
    }
}
