package cs2110;

/**
 * Models an account in our personal finance app.
 */
public interface Account {

    /**
     * Return the name associated with this account.
     */
    String name();

    /**
     * Returns the total balance, in cents, of the account.
     */
    int balance();

    /**
     * Attempts to deposit the specified `amount`, in cents, to the balance of the account, and
     * returns whether this transaction was successful. If this transaction is successful, it is
     * logged with the given `memo`. Otherwise, no changes are made to this account, and no
     * transaction is logged. Requires that `amount > 0`.
     */
    boolean depositFunds(int amount, String memo);

    /**
     * Attempts to transfer the specified `amount`, in cents, from this account to
     * `receivingAccount` and returns whether this transaction was successful. If this transaction
     * is successful, it is logged to both accounts. Otherwise, no changes are
     * made to either account, and no transaction is logged. Requires that `amount > 0`.
     */
    boolean transferFunds(Account receivingAccount, int amount);

    /**
     * Called once at the end of each month to return a `String` summarizing the account's initial
     * balance that month, all transactions made during that month, and its final balance.
     */
    String transactionReport();
}