package cs2110;

import static org.junit.jupiter.api.Assertions.*;

import org.junit.jupiter.api.Test;

class FractionTest {

    @Test
    void testNormalFraction() {
        assertEquals("1/2", new Fraction(1, 2).getReducedForm());
        assertEquals("1/3", new Fraction(1, 3).getReducedForm());
        assertEquals("2/1", new Fraction(2, 1).getReducedForm());
    }

    @Test
    void testReducedForm() {
        assertEquals("1/2", new Fraction(2, 4).getReducedForm());
        assertEquals("1/3", new Fraction(3, 9).getReducedForm());
        assertEquals("2/1", new Fraction(100, 50).getReducedForm());
    }

    @Test
    void testZero() {
        assertEquals("0/1", new Fraction(0, 1).getReducedForm());
        assertEquals("0/1", new Fraction(0, 8).getReducedForm());
        assertEquals("0/1", new Fraction(0, 20).getReducedForm());
    }

    @Test
    void testDouble() {
        Fraction f = new Fraction(1, 4);
        f.doubleMe();
        assertEquals("1/2", f.getReducedForm());
    }

    @Test
    void testNegative() {
        assertEquals("-1/2", new Fraction(1, -2).getReducedForm());
    }
}
