package cs2110;

public class Counter {

    /**
     * The value displayed on the counter. Must have `0 <= count <= 9999`.
     */
    private int count;

    /**
     * Constructs a new counter object that displays the count 0.
     */
    public Counter() {
        this.count = 0;
    }

    /**
     * Returns the current value displayed by this counter.
     */
    public int count() {
        return this.count;
    }

    /**
     * Increases the value displayed by this counter by 1. If `count` was 9999, it instead rolls
     * over and resets to 0.
     */
    public void increment() {
        if (this.count < 9999) {
            this.count++;
        } else {
            this.reset();
        }
    }

    /**
     * Resets the value displayed by this counter to 0.
     */
    public void reset() {
        this.count = 0;
    }
}