package cs2110;

import static org.junit.jupiter.api.Assertions.*;

import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;

/**
 * Contains tests that are common to all sorting routines.
 */
public abstract class SortingTest {

    /**
     * This method should be used in the tests in place of a call to a specific sorting method. It
     * allows us to run the same set of tests against all the sorting methods at once (using a
     * technique we'll learn about soon called the "template method pattern").
     */
    abstract void sort(int[] a);

    @DisplayName("WHEN we attempt to sort an empty array, THEN our sorting methods return without "
            + "crashing.")
    @Test
    void testEmpty() {
        sort(new int[0]);
    }

    @DisplayName("WHEN we sort an array with one element, THEN this element is unchanged.")
    @Test
    void testOneElement() {
        int[] a = {1};
        sort(a);
        assertArrayEquals(new int[]{1}, a);
    }

    @DisplayName("WHEN we sort an array with two elements in sorted order, THEN the array is unchanged.")
    @Test
    void testTwoElementsSorted() {
        int[] a = {1,2};
        sort(a);
        assertArrayEquals(new int[]{1,2}, a);
    }

    @DisplayName("WHEN we sort an array with two elements in descending order, THEN these elements "
            + "are swapped.")
    @Test
    void testTwoElementsUnsorted() {
        int[] a = {2,1};
        sort(a);
        assertArrayEquals(new int[]{1,2}, a);
    }

    @DisplayName("WHEN we sort an array with two equal elements, THEN these elements remain unchanged.")
    @Test
    void testTwoElementsSame() {
        int[] a = {2,2};
        sort(a);
        assertArrayEquals(new int[]{2,2}, a);
    }

    @DisplayName("WHEN we sort an array with three distinct elements, THEN these elements are"
            + "rearranged into sorted order.")
    @Test
    void testThreeElements() {
        // check all six orders
        int[] a = {1,2,3};
        sort(a);
        assertArrayEquals(new int[]{1,2,3}, a);

        a = new int[]{1,3,2};
        sort(a);
        assertArrayEquals(new int[]{1,2,3}, a);

        a = new int[]{2,1,3};
        sort(a);
        assertArrayEquals(new int[]{1,2,3}, a);

        a = new int[]{2,3,1};
        sort(a);
        assertArrayEquals(new int[]{1,2,3}, a);

        a = new int[]{3,1,2};
        sort(a);
        assertArrayEquals(new int[]{1,2,3}, a);

        a = new int[]{3,2,1};
        sort(a);
        assertArrayEquals(new int[]{1,2,3}, a);
    }

    @DisplayName("WHEN we sort an large array, THEN its elements are rearranged into sorted order.")
    @Test
    void testManyElements() {
        int[] a = {5,2,7,3,4,1,6,2,8,3,4,7,1,5,4};
        sort(a);
        assertArrayEquals(new int[]{1,1,2,2,3,3,4,4,4,5,5,6,7,7,8}, a);
    }
}

class InsertionSortTest extends SortingTest {

    @Override
    void sort(int[] a) {
        Sorting.insertionSort(a);
    }
}

class MergeSortTest extends SortingTest {

    @Override
    void sort(int[] a) {
        Sorting.mergeSort(a);
    }
}

class QuicksortTest extends SortingTest {

    @Override
    void sort(int[] a) {
        Sorting.quicksort(a);
    }
}
