package cs2110;

import static org.junit.jupiter.api.Assertions.*;

import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

public class SearchTest {

    @DisplayName("Linear Search:")
    @Nested
    class LinearSearchTest {

        @DisplayName("WHEN a value is present once in an array, THEN a linear search for this "
                + "value returns its index.")
        @Test
        void testLinearSearchPresentOnce() {
            assertEquals(0, Search.linearSearch(new int[]{1}, 1), "As the only value");
            assertEquals(0, Search.linearSearch(new int[]{1, 2, 3}, 1), "As the first value");
            assertEquals(2, Search.linearSearch(new int[]{3, 2, 1}, 1), "As the last value");
            assertEquals(1, Search.linearSearch(new int[]{2, 1, 3}, 1), "As a middle value");
        }

        @DisplayName("WHEN an array is empty, THEN a linear search for any value in that array "
                + "should return 0.")
        @Test
        void testLinearSearchEmpty() {
            assertEquals(0, Search.linearSearch(new int[]{}, 1));
        }

        @DisplayName("WHEN an array does not contain a target value, THEN a linear search for that "
                + "value returns the length of the array.")
        @Test
        void testLinearSearchAbsent() {
            assertEquals(3, Search.linearSearch(new int[]{1, 2, 3}, 0));
            assertEquals(5, Search.linearSearch(new int[]{1, 2, 3, 5, 6}, 4));
        }

        @DisplayName(
                "WHEN an array contains multiple copies of a target value, THEN a linear search "
                        + "returns the smallest index where that value occurs.")
        @Test
        void testLinearSearchMultiplePresent() {
            assertEquals(0, Search.linearSearch(new int[]{1, 2, 3, 4, 5, 6, 1}, 1));
            assertEquals(1, Search.linearSearch(new int[]{1, 2, 2, 3, 4, 5, 6}, 2));
            assertEquals(2, Search.linearSearch(new int[]{1, 2, 3, 4, 5, 3, 6}, 3));
        }
    }

    @DisplayName("Binary Search:")
    @Nested
    class BinarySearchTest {

        @DisplayName(
                "WHEN a sorted array contains a single instance of a target value, THEN a binary "
                        + "search for this value returns its index.")
        @Test
        void testBinarySearchPresentOnce() {
            // test all possible indices of a small array to confirm windowing is happening correctly
            assertEquals(0, Search.binarySearch(new int[]{0, 1, 2, 3, 4, 5, 6, 7}, 0));
            assertEquals(1, Search.binarySearch(new int[]{0, 1, 2, 3, 4, 5, 6, 7}, 1));
            assertEquals(2, Search.binarySearch(new int[]{0, 1, 2, 3, 4, 5, 6, 7}, 2));
            assertEquals(3, Search.binarySearch(new int[]{0, 1, 2, 3, 4, 5, 6, 7}, 3));
            assertEquals(4, Search.binarySearch(new int[]{0, 1, 2, 3, 4, 5, 6, 7}, 4));
            assertEquals(5, Search.binarySearch(new int[]{0, 1, 2, 3, 4, 5, 6, 7}, 5));
            assertEquals(6, Search.binarySearch(new int[]{0, 1, 2, 3, 4, 5, 6, 7}, 6));
            assertEquals(7, Search.binarySearch(new int[]{0, 1, 2, 3, 4, 5, 6, 7}, 7));

            // test a couple other array sizes to make sure midpoint calculation works
            assertEquals(2, Search.binarySearch(new int[]{1, 2, 3, 4, 5, 6, 7}, 3));
            assertEquals(4, Search.binarySearch(new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9}, 5));
        }

        @DisplayName("WHEN an array is empty, THEN a binary search for any value in that array "
                + "should return 0.")
        @Test
        void testBinarySearchEmpty() {
            assertEquals(0, Search.binarySearch(new int[]{}, 1));
        }

        @DisplayName(
                "WHEN a target value is smaller than all entries in a sorted array, THEN a binary "
                        + "search for that value should return 0.")
        @Test
        void testBinarySearchTooSmall() {
            assertEquals(0, Search.binarySearch(new int[]{1, 2, 3, 4}, 0));
            assertEquals(0, Search.binarySearch(new int[]{2, 4, 7, 9, 13}, 1));
        }

        @DisplayName(
                "WHEN a target value is larger than all entries in a sorted array, THEN a binary "
                        + "search for that value should return the array length.")
        @Test
        void testBinarySearchTooBig() {
            assertEquals(4, Search.binarySearch(new int[]{1, 2, 3, 4}, 5));
            assertEquals(5, Search.binarySearch(new int[]{2, 4, 7, 9, 13}, 22));
        }

        @DisplayName(
                "WHEN a target value is absent from a sorted array AND the array contains entries "
                        + "that are both smaller and larger than that target value, THEN a binary search for "
                        + "that value should return the index of the smallest entry larger than it.")
        @Test
        void testBinarySearchMissingMiddle() {
            int[] nums = {1, 2, 4, 5};
            int target = 3;
            int loc = Search.binarySearch(nums, target);
            assertEquals(2, loc); // option 1: check for the pre-computed index
            assertTrue(target > nums[loc - 1]); // option 2: check the post-condition from the spec
            assertTrue(target <= nums[loc]);
        }

        @DisplayName(
                "WHEN a sorted array contains multiple copies of a target value, THEN a binary "
                        + "search returns the smallest index where that value occurs.")
        @Test
        void testBinarySearchMultiplePresent() {
            assertEquals(4, Search.binarySearch(new int[]{1, 2, 3, 4, 5, 5, 6}, 5),
                    "first copy found first");
            assertEquals(1, Search.binarySearch(new int[]{1, 2, 2, 2, 2, 4, 5, 6}, 2),
                    "last copy found first");
            assertEquals(2, Search.binarySearch(new int[]{1, 2, 3, 3, 3, 3, 4}, 3),
                    "middle copy found first");
        }
    }
}
