package cs2110;

/**
 * Contains static methods to perform linear and binary search over int[] arrays.
 */
public class Search {

    /**
     * Returns the smallest index `i` such that `a[i] == v` or returns
     * `a.length` if `a` does not contain `v`.
     */
    static int linearSearchLecture(int[] a, int v) {
        // Note: This is the version of linear search that we developed during the lecture with
        // a more straightforward loop guard

        int i = 0;
        /* Loop invariant: `a[..i)` does not contain `v`. */
        while (i < a.length) {
            if (a[i] == v) {
                return i;
            }
            i++;
        }
        return i;
    }

    
    /**
     * Returns the smallest index `i` such that `a[i] == v` or returns
     * `a.length` if `a` does not contain `v`.
     */
    static int linearSearch(int[] a, int v) {
        // Note: This is a streamlined version of linear search that incorporates the conditional
        // statement within the loop body into the loop guard.

        int i = 0;
        /* Loop invariant: `a[..i)` does not contain `v`. */
        while (i < a.length && a[i] != v) {
            i++;
        }
        return i;
    }

    /**
     * Returns the value `r` with `0 <= r <= a.length` such that `a[..r) < v`
     * and `a[r..] >= v`. Requires that `a` is sorted (in ascending order).
     */
    static int binarySearch(int[] a, int v) {
        int l = 0; // left window boundary (inclusive)
        int r = a.length; // right window boundary (exclusive)
        /* Loop invariant: `a[..l) < v`, `a[r..] >= v` */
        while (l < r) {
            int m = l + (r - l)/2; // midpoint
            if (a[m] < v) {
                l = m + 1;
            } else {
                r = m;
            }
        }
        return r;
    }

}
