package cs2110;

public class Invariants {

    /**
     * Returns the number of occurrences of `key` among the elements in array `a`.
     */
    static int frequencyOf(int key, int[] a) {
        int i = 0; // next index of `a` to check
        int count = 0;
        /*
         * Loop invariant: `count` = number of occurrences of `key` in `a[..i)`
         */
        while (i < a.length) {
            if (a[i] == key) {
                count++;
            }
            i++;
        }
        return count;
    }

    /**
     * Returns an *index* of the minimum element in `a`. Requires that `a` contains at least one
     * element.
     */
    static int argmin(double[] a) {
        int i = 1;
        double min = a[0];
        int loc = 0;
        /*
         * Loop invariant: `a[..i) >= min`, `a[loc] == min`
         */
        while (i < a.length) {
            if (a[i] < min) {
                min = a[i];
                loc = i;
            }
            i++;
        }
        return loc;
    }

    /**
     * Swaps the entries `a[x]` and `a[y]`. Requires that `0 <= x < a.length` and `0 <= y <
     * a.length`.
     */
    static void swap(int[] a, int x, int y) {
        int temp = a[x];
        a[x] = a[y];
        a[y] = temp;
    }

    /**
     * Rearranges the elements of `a` so that all even elements appear before all odd elements.
     * Returns the index of the first odd element, or returns `a.length` if all elements are even.
     */
    static int paritySplit(int[] a) {
        int i = 0;
        int j = a.length;
        /*
         * Loop invariant: `a[..i)` is even, `a[j..]` is odd
         */
        while (i < j) {
            if (a[i] % 2 == 0) {
                i++;
            } else {
                swap(a, i, j - 1);
                j--;
            }
        }
        return j;
    }
}
