package cs2110;

import static org.junit.jupiter.api.Assertions.*;

import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;

public class SpecsTest {
    /* Uppercase At */

    @DisplayName("WHEN we call `uppercaseAt()` with a String with an uppercase "
            + "English alphabet character at the beginning and i=0, THEN it should "
            + "return true.")
    @Test
    void testUppercaseAtBeginning() {
        assertTrue(Specs.uppercaseAt("Hello", 0));
    }

    @DisplayName("WHEN we call `uppercaseAt()` with a String with an uppercase "
            + "English alphabet character at the end and i=length-1, THEN it should "
            + "return true.")
    @Test
    void testUppercaseAtEnd() {
        assertTrue(Specs.uppercaseAt("applE", 4));
    }

    @DisplayName("WHEN we call `uppercaseAt()` with a String with an uppercase "
            + "English alphabet character in the middle, THEN it should return true.")
    @Test
    void testUppercaseInMiddle() {
        assertTrue(Specs.uppercaseAt("APPLE", 1));
        assertTrue(Specs.uppercaseAt("baNana", 2));
        assertTrue(Specs.uppercaseAt("1d5nal#fRa3", 8));
    }

    @DisplayName("WHEN we call `uppercaseAt()` with a String with a lowercase "
            + "English alphabet character at the beginning and i=0, THEN it should "
            + "return false.")
    @Test
    void testLowercaseAtBeginning() {
        assertFalse(Specs.uppercaseAt("goodbye", 0));
    }

    @DisplayName("WHEN we call `uppercaseAt()` with a String with a lowercase "
            + "English alphabet character at the end and i=length-1, THEN it should "
            + "return false.")
    @Test
    void testLowercaseAtEnd() {
        assertFalse(Specs.uppercaseAt("GRAPe", 4));
    }

    @DisplayName("WHEN we call `uppercaseAt()` with a String with a lowercase "
            + "English alphabet character in the middle, THEN it should return false.")
    @Test
    void testLowercaseInMiddle() {
        assertFalse(Specs.uppercaseAt("apple", 2));
        assertFalse(Specs.uppercaseAt("PAPAyA", 4));
        assertFalse(Specs.uppercaseAt("1d5nal#fRa3", 5));
    }

    @DisplayName("WHEN we call `uppercaseAt()` with on String with a non-alphabetic "
            + "character at index i, THEN it should return false.")
    @Test
    void testNonAlphabetic() {
        assertFalse(Specs.uppercaseAt("CA$H", 2));
        assertFalse(Specs.uppercaseAt("12345", 3));
    }

    @DisplayName("WHEN we call `uppercaseAt()` with on String with a non-English "
            + "uppercase alphabetic character at index i, THEN it should return true.")
    @Test
    void testOtherAlphabets() {
        assertTrue(Specs.uppercaseAt("ΑΒΓΔΕ", 2));
    }

    /* Zero Through - Testing Return Value */

    @DisplayName("WHEN we call `zeroThrough()` and the first entry of the array is "
            + "the key, THEN it should return 0.")
    @Test
    void testZeroThroughFirstReturned() {
        assertEquals(0, Specs.zeroThrough(new int[]{1, 2, 3, 4, 5}, 1));
    }

    @DisplayName("WHEN we call `zeroThrough()` and the key appears once in the middle "
            + "of the array, THEN that index should be returned.")
    @Test
    void testZeroThroughMiddleIndexReturned() {
        assertEquals(2, Specs.zeroThrough(new int[]{1, 2, 3, 4, 5}, 3));
    }

    @DisplayName("WHEN we call `zeroThrough()` and the last entry of the array is "
            + "the key, THEN it should return the last index.")
    @Test
    void testZeroThroughLastReturned() {
        assertEquals(4, Specs.zeroThrough(new int[]{1, 2, 3, 4, 5}, 5));
    }

    @DisplayName("WHEN we call `zeroThrough()` and the key is not present in the "
            + "array, THEN the array length should be returned.")
    @Test
    void testZeroThroughUnfoundReturn() {
        assertEquals(5, Specs.zeroThrough(new int[]{1, 2, 3, 4, 5}, 6));
    }

    @DisplayName("WHEN we call `zeroThrough()` and the key is present multiple "
            + "times, THEN the first index should be returned.")
    @Test
    void testZeroThroughMultipleKey() {
        assertEquals(1, Specs.zeroThrough(new int[]{1, 2, 3, 2, 1}, 2));
    }

    /* Zero Through - Testing Side Effect */

    @DisplayName("WHEN we call `zeroThrough()` and the key appears once "
            + ", THEN the key entries and all entries to its left are "
            + "zeroed out, and no entries to its right are zeroed out.")
    @Test
    void testZeroThroughZeroesCorrectly() {
        int[] nums = {1, 2, 3, 4, 5}; // save reference in local variable for later
        int loc = Specs.zeroThrough(nums,3);
        for (int i = 0; i <= loc; i++) {
            assertEquals(0, nums[i]);
        }
        for (int j = loc + 1; j < nums.length; j++) {
            assertNotEquals(0, nums[j]);
        }
    }

    @DisplayName("WHEN we call `zeroThrough()` and the key does not appear "
            + "in the array, THEN the entire array is zeroed out.")
    @Test
    void testZeroThroughZeroesAll() {
        int[] nums = {1, 2, 3, 4, 5}; // save reference in local variable for later
        Specs.zeroThrough(nums,6); // don't need to store return value
        for (int i = 0; i < nums.length; i++) {
            assertEquals(0, nums[i]);
        }
    }
}