package cs2110;

import static org.junit.jupiter.api.Assertions.*;

import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;

public class CleanDataTest {

    @DisplayName("WHEN the array is empty, THEN the `cleanData()` method returns without throwing "
            + "any exceptions.")
    @Test
    void testEmptyArray() {
        LoopInvariants.cleanData(new double[]{});
        // no assertions needed, if we make it here, the test passes
    }

    @DisplayName("WHEN all entries of the array are positive, THEN the `cleanData()` method "
            + "leaves the array entries unchanged.")
    @Test
    void testPositiveArray() {
        double[] readings = {0.1, 0.2, 0.3, 0.4};
        LoopInvariants.cleanData(readings);
        assertArrayEquals(new double[]{0.1, 0.2, 0.3, 0.4}, readings);
    }

    @DisplayName("WHEN all entries of the array are all zero, THEN the `cleanData()` method "
            + "leaves the array entries unchanged.")
    @Test
    void testZerosArray() {
        double[] readings = {0, 0, 0};
        LoopInvariants.cleanData(readings);
        assertArrayEquals(new double[]{0, 0, 0}, readings);
    }

    @DisplayName("WHEN all entries of the array are all negative, THEN the `cleanData()` method "
            + "replaces all of the entries with 0.")
    @Test
    void testNegativesArray() {
        double[] readings = {-0.1, -0.2, -0.3, -0.4};
        LoopInvariants.cleanData(readings);
        assertArrayEquals(new double[]{0, 0, 0, 0}, readings);
    }

    @DisplayName("WHEN the array includes a mix of positive, zero, and negative entries , THEN the "
            + "`cleanData()` method replaces all negative entries with 0 and leaves the remaining "
            + "entries unchanged.")
    @Test
    void testMixedArray() {
        double[] readings1 = {-2, -1, 0, 1, 2};
        LoopInvariants.cleanData(readings1);
        assertArrayEquals(new double[]{0, 0, 0, 1, 2}, readings1);

        // another order to check for spurious early termination
        double[] readings2 = {2, 1, 0, -1, -2};
        LoopInvariants.cleanData(readings2);
        assertArrayEquals(new double[]{2, 1, 0, 0, 0}, readings2);
    }

}
