package cs2110;

public class Practice {

    /**
     * Returns the median of the three given integers, `a`, `b`, and `c`. A number `m` is the
     * "median of 3" if there is at least one other number that is <= `m` and at least one other
     * number that is >= `m`.
     */
    static int med3(int a, int b, int c) {
        /* <RELEASE>
        // TODO 1: Use `if`-`else` statements to complete the definition of this method.
        throw new UnsupportedOperationException();
        </RELEASE> */
        if (a >= b && b >= c || c >= b && b >= a) {
            return b;
        } else if (b >= a && a >= c || c >= a && a >= b) {
            return a;
        } else {
            return c;
        }
    }

    /**
     * Returns the greatest common divisor of `m` and `n`. Requires that `0 < m <= n`.
     */
    static int gcdLoop(int m, int n) {
        assert 0 < m && m <= n;

        /* <RELEASE>
        // TODO 2: Compute the gcd using a `for`-loop to iterate over the values of
        //  {1,...,m}, checking which are divisors of both m and n.
        throw new UnsupportedOperationException();
        </RELEASE> */
        int gcd = 1;
        for (int i = 2; i <= m; i++) {
            if (m % i == 0 && n % i == 0) {
                gcd = i;
            }
        }
        return gcd;
    }

    /**
     * Returns the greatest common divisor of `m` and `n`. Requires that `0 < m <= n`.
     */
    static int gcdEuclideanIterative(int m, int n) {
        assert 0 < m && m <= n;

        /* <RELEASE>
        // TODO 3: Compute the gcd using a `while`-loop to instantiate the Euclidean algorithm:
        //  If m divides n, then gcd{m,n} = m. Otherwise, gcd{m,n} = gcd{m,n % m}.
        throw new UnsupportedOperationException();
        </RELEASE> */
        while (n % m != 0) {
            int t = m;
            m = n % m;
            n = t;
        }
        return m;
    }

    /**
     * Returns the greatest common divisor of `m` and `n`. Requires that `0 < m <= n`.
     */
    static int gcdEuclideanRecursive(int m, int n) {
        assert 0 < m && m <= n;

        /* <RELEASE>
        // TODO 4: Compute the gcd recursively using the Euclidean algorithm:
        //  If m divides n, then gcd{m,n} = m. Otherwise, gcd{m,n} = gcd{m,n % m}.
        throw new UnsupportedOperationException();
        </RELEASE> */
        return (n % m == 0) ? m : gcdEuclideanRecursive(n % m, m);
    }

    /**
     * Prints the outputs of a game of FizzBuzz on inputs 1,...,n (inclusive). A number is a "Fizz"
     * number if it is divisible by 3. A number is a "Buzz" number if it is divisible by 5. If a
     * number is a "Fizz" number and a "Buzz" number, "FizzBuzz" is printed. If a number is only a
     * "Fizz" number, "Fizz" is printed. If a number is only a "Buzz" number, "Buzz" is printed.
     * Otherwise, the number itself is printed. Each of the n outputs should be printed on a
     * separate line (use `System.out.println()`). Requires `n >= 1`.
     */
    static void fizzBuzz(int n) {
        assert n >= 1;

        /* <RELEASE>
        // TODO 5: Complete this method according to its specification.
        throw new UnsupportedOperationException();
        </RELEASE> */
        for (int i = 1; i <= n; i++) {
            if (i % 15 == 0) {
                System.out.println("FizzBuzz");
            } else if (i % 5 == 0) {
                System.out.println("Buzz");
            } else if (i % 3 == 0) {
                System.out.println("Fizz");
            } else {
                System.out.println(i);
            }
        }
    }

    /**
     * Prints the outputs of a game of FizzBuzz on inputs 1,...,n (inclusive) in the same manner as
     * the `fizzBuzz()` method, except now: A number is a "Fizz" number if it is divisible by 3 *or*
     * has a 3 in its base-10 representation. A number is a "Buzz" number if it is divisible by 5
     * *or* has a 5 in its base-10 representation.
     */
    static void fizzBuzzHard(int n) {
        assert n >= 1;

        /* <RELEASE>
        // TODO 6: Complete this method according to its specification.
        //  It may be helpful to write some *helper methods* to separate out some computation
        //  and make your logic easier to follow.
        throw new UnsupportedOperationException();
        </RELEASE> */
        for (int i = 1; i <= n; i++) {
            boolean f = fizzHard(i);
            boolean b = buzzHard(i);
            if (f && b) {
                System.out.println("FizzBuzz");
            } else if (b) {
                System.out.println("Buzz");
            } else if (f) {
                System.out.println("Fizz");
            } else {
                System.out.println(i);
            }
        }
    }

    /**
     * Returns whether the given `n` is a "Fizz" number in the hard version of FizzBuzz.
     */
    static boolean fizzHard(int n) {
        if (n % 3 == 0) {
            return true;
        }
        while (n > 0) { // there are more digits to inspect
            if (n % 10 == 3) { // inspect the rightmost digit
                return true;
            }
            n = n / 10; // "chop off" the rightmost digit
        }
        return false;
    }

    /**
     * Returns whether the given `n` is a "Buzz" number in the hard version of FizzBuzz.
     */
    static boolean buzzHard(int n) {
        if (n % 5 == 0) {
            return true;
        }
        while (n > 0) { // there are more digits to inspect
            if (n % 10 == 5) { // inspect the rightmost digit
                return true;
            }
            n = n / 10; // "chop off" the rightmost digit
        }
        return false;
    }
}
