package cs2110;

import java.awt.Color;
import java.awt.GridLayout;
import javax.swing.JPanel;

/**
 * Holds the grid of buttons that form a tic-tac-toe board.
 */
public class TicTacToeGrid extends JPanel {

    /**
     * Represents the current state of the TicTacToe game
     */
    private TicTacToe model;

    /**
     * The grid of buttons in each cell of this TicTacToe grid
     */
    private final TicTacToeCell[][] buttons;

    /**
     * Construct a JPanel with a 3 x 3 GridLayout of TicTacToeCell buttons.
     */
    public TicTacToeGrid() {
        model = new TicTacToe();

        buttons = new TicTacToeCell[3][3];

        setBackground(Color.BLACK);

        // A grid layout arranges components in a rectangular grid of equal-sized cells
        // The first two arguments are the dimensions of the grid (3 x 3)
        // The next two arguments (10 and 10) are the horizontal/vertical gaps between the cells
        setLayout(new GridLayout(3, 3, 10, 10));

        for (int i = 0; i < 3; i++) {
            for (int j = 0; j < 3; j++) {
                buttons[i][j] = new TicTacToeCell();
                add(buttons[i][j]); // add button to grid layout
            }
        }

        buttons[0][0].addSymbol('X');
        buttons[1][1].addSymbol('X');
        buttons[2][1].addSymbol('O');
        buttons[2][2].addSymbol('O');

    }
}