package cs2110;

import java.awt.BorderLayout;
import java.awt.Color;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;

/**
 * The primary class of our graphical Tic-Tac-Toe application.
 */
public class TicTacToeGraphical extends JFrame {

    /**
     * Constructs application window with title "Tic Tac Toe", a label displaying whose turn it
     * is at the top, a reset button at the bottom, and the game grid in the center.
     */
    public TicTacToeGraphical() {

        setTitle("Tic-Tac-Toe");
        setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE); // gentle way to close application
        ///setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        setResizable(false); // prevent resizing frame to make drawing code simpler

        TicTacToeGrid grid = new TicTacToeGrid();
        add(grid); // JFrame has default BorderLayout. This adds the grid to the center

        // create and add label for the player turn message to the top of the frame
        JLabel turnLabel = new JLabel("It's your turn Player X. Select a cell to claim.", SwingConstants.CENTER);
        turnLabel.setFont(turnLabel.getFont().deriveFont(16.0f)); // increase font size
        turnLabel.setBackground(Color.WHITE);
        turnLabel.setOpaque(true);
        turnLabel.setBorder(new EmptyBorder(10, 10, 10, 10)); // padding around text
        add(turnLabel, BorderLayout.NORTH);

        // create and add reset button to bottom of frame
        JButton resetButton = new JButton("Reset");
        resetButton.setFont(resetButton.getFont().deriveFont(20.0f)); // increase font size
        add(resetButton, BorderLayout.SOUTH);

        pack(); // adjust size of frame based on its components
    }

    /**
     * Start the application
     */
    public static void main(String[] args) {
        // Creation of JFrame must occur on Event Dispatch Thread.
        SwingUtilities.invokeLater( () -> {
            TicTacToeGraphical game = new TicTacToeGraphical();
            //game.setLocation(800, -700); // for external monitor above the primary monitor
            game.setVisible(true);
        });
    }
}
