package cs2110;

import java.util.Scanner;

public class TicTacToeConsole {

    public static void main(String[] args) {
        TicTacToe ttt = new TicTacToe();

        try (Scanner in = new Scanner(System.in)) {
            while (!ttt.gameOver()) {
                printBoard(ttt);
                System.out.println("It's your turn Player " + ttt.currentPlayer() + ".");
                int pos = 0; // next move position
                boolean validMove = false; // whether the entered move is valid
                while (!validMove) {
                    System.out.print("Where would you like to go? ");
                    pos = in.nextInt();
                    if (pos < 0 || pos > 8 || ttt.contentsOf(pos / 3, pos % 3) != ' ') {
                        System.out.println("The position you entered is invalid. Try again.");
                    } else {
                        validMove = true;
                    }
                }
                ttt.processMove(pos / 3, pos % 3);
            }
        }

        printBoard(ttt);
        if (ttt.winner() != 'T') {
            System.out.println("Congratulations Player " + ttt.winner() + "!");
        } else {
            System.out.println("The game ended in a tie.");
        }
    }

    /**
     * Prints the current state of the board for the game instance `ttt`
     */
    private static void printBoard(TicTacToe ttt) {

        System.out.println(); // blank line
        System.out.println(cell(ttt, 0, 0) + "┃" + cell(ttt, 0, 1) + "┃" + cell(ttt, 0, 2));
        System.out.println("━━━╋━━━╋━━━");
        System.out.println(cell(ttt, 1, 0) + "┃" + cell(ttt, 1, 1) + "┃" + cell(ttt, 1, 2));
        System.out.println("━━━╋━━━╋━━━");
        System.out.println(cell(ttt, 2, 0) + "┃" + cell(ttt, 2, 1) + "┃" + cell(ttt, 2, 2));
        System.out.println(); // blank line
    }

    /**
     * Returns a 3-character string representing the current state of the cell at position
     * (`row`,`col`) in the game instance `ttt`. If the cell is empty, "(#)" is printed, # is the
     * index of that cell. Otherwise, " X " or " O " is printed.
     */
    private static String cell(TicTacToe ttt, int row, int col) {
        if (ttt.contentsOf(row, col) == ' ') {
            return "(" + (3 * row + col) + ")";
        } else {
            return " " + ttt.contentsOf(row, col) + " ";
        }

    }
}
