package cs2110;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JButton;

/**
 * Models a cell in our tic-tac-toe game.
 */
public class TicTacToeCell extends JButton {
    /**
    Constants for the color palette to make it easier to reuse and change colors
    */
    private final Color LIGHT_RED = new Color(255, 170, 170);
    private final Color LIGHT_GREEN = new Color(160,255,170);

    private final Color LIGHT_ORANGE = new Color(255, 220, 170);
    private final Color LIGHT_BLUE = new Color(150,180,255);

    /*
    // This color palette is less accessible for colorblind users
    // see also: https://www.color-blindness.com/coblis-color-blindness-simulator/
    private final Color X_COLOR = Color.RED;
    private final Color X_BG_COLOR = LIGHT_RED;
    private final Color O_COLOR = Color.GREEN;
    private final Color O_BG_COLOR = LIGHT_GREEN;
     */

    private final Color X_COLOR = Color.ORANGE;
    private final Color X_BG_COLOR = LIGHT_ORANGE;
    private final Color O_COLOR = Color.BLUE;
    private final Color O_BG_COLOR = LIGHT_BLUE;

    /**
     * The contents of this game cell. Must be either ' ', 'X', or 'O'.
     */
    private char symbol;

    public TicTacToeCell() {
        symbol = ' ';
        setPreferredSize(new Dimension(120, 120));
        setBorderPainted(false);
        setFocusable(false);
        setOpaque(true);
    }

    /**
     * Writes the given `symbol` into this cell, updating its state. Requires that
     * symbol is 'X' or 'O'.
     */
    public void addSymbol(char symbol) {
        assert symbol == 'X' || symbol == 'O';
        this.symbol = symbol;
        repaint();
        setEnabled(false); // can't select this cell again
    }

    /**
     * Removes the symbol (if any) from this cell.
     */
    public void reset() {
        symbol = ' ';
        setEnabled(true); // this cell can now be selected
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);

        // background
        g.setColor( switch (symbol) {
            case 'X' -> X_BG_COLOR;
            case 'O' -> O_BG_COLOR;
            default -> Color.WHITE;
        });
        g.fillRect(0, 0, 120, 120);

        // symbol
        if (symbol == 'X') {
            int[] xcoords = {10, 20, 60, 100, 110, 70, 110, 100, 60, 20, 10, 50, 10};
            int[] ycoords = {20, 10, 50, 10, 20, 60, 100, 110, 70, 110, 100, 60, 20};
            g.setColor(X_COLOR);
            g.fillPolygon(xcoords, ycoords, 12);
            g.setColor(Color.BLACK);
            g.drawPolyline(xcoords, ycoords, 13);
        } else if (symbol == 'O') {
            g.setColor(O_COLOR);
            g.fillOval(10, 10, 100, 100);
            g.setColor(O_BG_COLOR);
            g.fillOval(25, 25, 70, 70);
            g.setColor(Color.BLACK);
            g.drawOval(10, 10, 100, 100);
            g.drawOval(25, 25, 70, 70);
        }
    }
}
