package cs2110;

import java.util.LinkedHashMap;

/**
 * Represents a vertex in this graph responsible for tracking its neighbors.
 */
public class AdjListVertex<E extends Edge<AdjListVertex<E>>> implements Vertex<E> {

    /**
     * The label of this vertex
     */
    String label;

    /**
     * A map associating the labels of this vertex's neighbors with the edges connecting to
     * them.
     */
    LinkedHashMap<String,E> outEdges;

    /**
     * Constructs a new vertex with the given `label`.
     */
    AdjListVertex(String label) {
        this.label = label;
        outEdges = new LinkedHashMap<>();
    }

    @Override
    public String label() {
        return label;
    }

    @Override
    public int degree() {
        return outEdges.size();
    }

    @Override
    public boolean hasNeighbor(String headLabel) {
        return outEdges.containsKey(headLabel);
    }

    @Override
    public E edgeTo(String headLabel) {
        assert hasNeighbor(headLabel);
        return outEdges.get(headLabel);
    }

    @Override
    public Iterable<E> outgoingEdges() {
        return outEdges.values();
    }
}