package cs2110;

import java.io.IOException;

public class TraversalDemo {
    public static void main(String[] args) throws IOException {
        // Create graph from slide deck.
        AdjListGraph g = new AdjListGraph();
        g.addVertex("s");
        g.addVertex("a");
        g.addVertex("b");
        g.addVertex("c");
        g.addVertex("d");
        g.addVertex("t");
        g.addEdge("s", "a");
        g.addEdge("a", "d");
        g.addEdge("a", "b");
        g.addEdge("a", "c");
        g.addEdge("b", "s");
        g.addEdge("c", "t");
        g.addEdge("d", "b");
        g.addEdge("d", "t");
        g.addEdge("d", "c");

        /* DFS Visitation Order */
        System.out.println("DFS Visitation Order (starting from s): ");
        Traversals.dfsTraverse(g.getVertex("s"), v -> System.out.print(v + " "), v -> {});
        System.out.println("\n");

        /* DFS Settlement Order */
        System.out.println("DFS Settlement Order (starting from s): ");
        Traversals.dfsTraverse(g.getVertex("s"), v -> {}, v -> System.out.print(v + " "));
        System.out.println("\n");

        /* BFS Visitation Order */
        System.out.println("BFS Visitation Order (starting from s): ");
        Traversals.bfsQueue(g.getVertex("s"), v -> System.out.print(v + " "));
        System.out.println("\n");
    }
}