package cs2110;

/**
 * Represents a mutable, directed, simple graph whose vertices are labeled by Strings.
 */
public interface Graph<V extends Vertex<?>, E extends Edge<V>> {

    /* ***********************************************************************
     * Query methods                                                         *
     * ***********************************************************************/

    /**
     * Returns the number of vertices in this graph.
     */
    int vertexCount();

    /**
     * Returns the number of edges in this graph.
     */
    int edgeCount();

    /**
     * Returns whether there is a vertex with the given `label` in this graph.
     */
    boolean hasVertex(String label);

    /**
     * Returns the vertex with the given `label`. Requires that `hasVertex(label) == true`.
     */
    V getVertex(String label);

    /**
     * Returns whether there is an edge with tail labeled `tailLabel` and head labeled `headLabel` in
     * this graph.
     */
    boolean hasEdge(String tailLabel, String headLabel);

    /**
     * Returns the edge from vertex `tailLabel` to vertex `headLabel`.
     * Requires that `hasEdge(tailLabel, headLabel) == true`.
     */
    E getEdge(String tailLabel, String headLabel);

    /* ***********************************************************************
     * Mutation methods                                                      *
     * ***********************************************************************/

    /**
     * Adds a vertex with the given `label` to this graph. Throws an 
     * `IllegalArgumentException` if there is already a vertex in the graph with 
     * this label.
     */
    void addVertex(String label);

    /**
     * Adds an edge between the vertices with the given labels and returns a reference to this new
     * edge. Throws an IllegalArgumentException if either endpoint of this edge is not a vertex in
     * this graph or if the graph already contains an edge between these endpoints.
     */
    E addEdge(String tailLabel, String headLabel);

    /* ***********************************************************************
     * Iteration methods                                                     *
     * ***********************************************************************/

    /**
     * Returns an object supporting iteration over all the vertices in this graph.
     */
    Iterable<V> vertices();

    /**
     * Returns an object supporting iteration over all the edges in this graph.
     */
    Iterable<E> edges();
}
