package cs2110;

/**
 * Models a non-negative int-weighted edge in a directed graph. Requires that `weight >= 0`.
 */
public class WeightedEdge<V> implements Edge<V> {
    /**
     * The vertex at the tail of this edge.
     */
    private final V tail;

    /**
     * The vertex at the head of this edge.
     */
    private final V head;

    /**
     * The weight of this edge. Must be >= 0. New edges default to weight 1.
     */
    private int weight;

    /**
     * Constructs a new WeightedEdge with the given `tail` and `head` vertices and default weight 1.
     */
    public WeightedEdge(V tail, V head) {
        this.tail = tail;
        this.head = head;
        weight = 1;
    }

    @Override
    public V tail() {
        return tail;
    }

    @Override
    public V head() {
        return head;
    }

    /**
     * Returns the weight of this edge.
     */
    public int weight() {
        return weight;
    }

    /**
     * Updates the weight of this edge to the given value. Requires `weight >= 0`.
     */
    public void setWeight(int weight) {
        assert weight >= 0;
        this.weight = weight;
    }
}
