package cs2110;

import java.util.ArrayList;
import java.util.List;

public class GraphDemo {

    @SuppressWarnings("unchecked")
    public static void main(String[] args) {
        List<Graph<?,WeightedEdge<?>>> graphs = new ArrayList<>();

        Graph<?,?> g1 = new AdjListGraph();
        graphs.add((Graph<?,WeightedEdge<?>>)g1);

        Graph<?,?> g2 = new AdjMatrixGraph();
        graphs.add((Graph<?,WeightedEdge<?>>)g2);

        for (Graph<?,WeightedEdge<?>> graph : graphs) {
            graph.addVertex("A");
            graph.addVertex("B");
            graph.addVertex("C");
            graph.addVertex("D");

            graph.addEdge("A", "B").setWeight(10);
            graph.addEdge("A", "C").setWeight(5);
            graph.addEdge("A", "D").setWeight(7);
            graph.addEdge("B", "A").setWeight(2);
            graph.addEdge("B", "D").setWeight(3);
            graph.addEdge("C", "B").setWeight(4);
            graph.addEdge("D", "C").setWeight(8);
        }

        System.out.println("\nAdjacency List Representation:");
        System.out.println(graphs.get(0));

        System.out.println("Adjacency Matrix Representation:");
        System.out.println(graphs.get(1));
    }
}
