package cs2110;

/**
 * Models an unordered collection of elements of type T without duplicates.
 */
public interface Set<T> extends Iterable<T> {

    /**
     * Attempts to add the given `elem` to this set. Returns true if `elem` was successfully added,
     * and returns false if `elem` could not be added because it was already present in the set.
     * Requires that `elem != null`.
     */
    boolean add(T elem);

    /**
     * Returns whether the given `elem` is present in this set. Requires that `elem != null`.
     */
    boolean contains(T elem);

    /**
     * Returns the number of elements present in this set.
     */
    int size();

    /**
     * Attempts to remove the given `elem` from this set. Returns true if `elem` was successfully
     * removed, and returns false if `elem` could not be removed because it was not present in the 
     * set. Requires that `elem != null`.
     */
    boolean remove(T elem);
}
