package cs2110;

/**
 * An unordered collection that associates keys of type K to values of type V.
 */
public interface Map<K, V> {

    /**
     * Updates the map to associate the given `value` with the given `key`. This adds a new entry to
     * the map if `key` was not present in the map and modifies an existing entry if `key` was
     * present. Requires that `key != null`.
     */
    void put(K key, V value);

    /**
     * Returns whether this map contains an entry with the given `key`. Requires that `key !=
     * null`.
     */
    boolean containsKey(K key);

    /**
     * Returns the value associated with the given `key`. Requires that `key != null` and
     * `containsKey(key) == true`.
     */
    V get(K key);

    /**
     * Returns the number of (key,value) pairs stored in this map.
     */
    int size();

    /**
     * Returns the value associated with the given `key` and removes this (key,value) pair from the
     * map. Requires that `key != null` and `containsKey(key) == true`.
     */
    V remove(K key);

    /**
     * Returns the set of keys contained in this map.
     */
    Set<K> keySet();
}
