package cs2110;

import java.util.ArrayList;
import java.util.Iterator;

/**
 * An implementation of the Set interface leveraging composition with an ArrayList that maintains a
 * sorted invariant.
 */
public class SortedListSet<T extends Comparable<T>> implements Set<T> {
// Note: T must be Comparable so its elements can be sorted

    /**
     * The ArrayList containing the elements of this set in sorted order.
     */
    private final ArrayList<T> list;

    /**
     * Constructs a ListSet with no elements.
     */
    public SortedListSet() {
        list = new ArrayList<>();
    }

    @Override
    public boolean add(T elem) {
        assert elem != null;
        int i = find(elem);
        if (i < list.size() && list.get(i).equals(elem)) {
            return false;
        }
        list.add(i, elem);
        return true;
    }

    /**
     * Returns the value `r` with `0 <= r <= list.size()` such that `list[..r) < v` and `list[r..)
     * >= v`.
     */
    private int find(T target) {
        // binary search:
        int l = 0; // left window boundary (inclusive)
        int r = list.size(); // right window boundary (exclusive)
        /* Loop invariant: `list[..l) < v`, `list[r..] >= v` */
        while (l < r) {
            int m = l + (r - l) / 2; // midpoint
            int c = target.compareTo(list.get(m)); // result of comparison
            if (c == 0) { // target at midpoint
                return m;
            } else if (c > 0) { // target bigger than midpoint
                l = m + 1;
            } else { // target smaller than midpoint
                r = m;
            }
        }
        return r;
    }

    @Override
    public boolean contains(T elem) {
        assert elem != null;
        int i = find(elem);
        return i < list.size() && list.get(i).equals(elem);
    }

    @Override
    public int size() {
        return list.size();
    }

    @Override
    public boolean remove(T elem) {
        assert elem != null;
        int i = find(elem);
        if (i == list.size() || !list.get(i).equals(elem)) {
            return false;
        }
        list.remove(i);
        return true;
    }

    @Override
    public Iterator<T> iterator() {
        return list.iterator();
    }
}