package cs2110;

/**
 * A queue of elements of type T that are removed in priority order.
 */
public interface PriorityQueue<T> {

    /**
     * Adds the given `elem` to the queue associated with the given `priority`.
     */
    void add(T elem, double priority);

    /**
     * Returns `true` if there are currently no elements stored in this queue, otherwise returns
     * `false`.
     */
    boolean isEmpty();

    /**
     * Returns the element from the queue with the highest priority without removing it. Requires
     * that this priority queue is not empty.
     */
    T peek();

    /**
     * Removes and returns the element from the queue with the highest priority. Requires that this
     * priority queue is not empty.
     */
    T remove();
}
