package cs2110;

import java.util.Arrays;
import java.util.Comparator;

public class PointSortDemo {

    /* *******************************************
     * Using Comparable                          *
     *********************************************/

    /** Sorts the entries of `a` using the insertion sort algorithm. */
    static <T extends Comparable<T>> void insertionSort(T[] a) {
        /* Loop invariant: a[..i) is sorted, a[i..] are unchanged. */
        for (int i = 0; i < a.length; i++) {
            insert(a, i);
        }
    }

    /**
     * Inserts entry `a[i]` into its sorted position in `a[..i)` such that `a[..i]`
     * contains the same entries in sorted order. Requires that `0 <= i < a.length`
     * and `a[..i)` is sorted.
     */
    static <T extends Comparable<T>> void insert(T[] a, int i) {
        assert 0 <= i && i < a.length; // defensive programming
        int j = i;
        while (j > 0 && a[j - 1].compareTo(a[j]) > 0) {
            swap(a, j - 1, j);
            j--;
        }
    }

    /**
     * Swaps the entries `a[i]` and `a[j]`. Requires that `0 <= i < a.length` and
     * `0 <= j < a.length`.
     */
    static <T> void swap(T[] a, int i, int j) {
        T temp = a[i];
        a[i] = a[j];
        a[j] = temp;
    }

    /* *******************************************
     * Using Comparator                          *
     *********************************************/

    /** Sorts the entries of `a` using the insertion sort algorithm. */
    static <T> void insertionSort(T[] a, Comparator<T> cmp) {
        /* Loop invariant: a[..i) is sorted, a[i..] are unchanged. */
        for (int i = 0; i < a.length; i++) {
            insert(a, cmp, i);
        }
    }

    /**
     * Inserts entry `a[i]` into its sorted position in `a[..i)` such that `a[..i]`
     * contains the same entries in sorted order. Requires that `0 <= i < a.length`
     * and `a[..i)` is sorted.
     */
    static <T> void insert(T[] a, Comparator<T> cmp, int i) {
        assert 0 <= i && i < a.length; // defensive programming
        int j = i;
        while (j > 0 && cmp.compare(a[j - 1],a[j]) > 0) {
            swap(a, j - 1, j);
            j--;
        }
    }

    public static void main(String[] args) {
        Point[] points = new Point[]{
            new Point(1,3),
            new Point(2,6),
            new Point(4,5),
            new Point(3,2),
            new Point(0,7),
            new Point(4,3),
            new Point(3,4),
            new Point(5,0)
        };

        System.out.println("Original:");
        System.out.println(Arrays.toString(points));

        System.out.println("\nSorted with Comparable (by distance from origin):");
        insertionSort(points);
        System.out.println(Arrays.toString(points));

        System.out.println("\nSorted with Comparable (lexicographically):");
        insertionSort(points, new PointLex());
        System.out.println(Arrays.toString(points));
    }
}
