package cs2110;

import java.util.Iterator;

public class TreeDemo {
    public static void main(String[] args) {
        BinaryTree<Character> tree = new ImmutableBinaryTree<>('A',
                new ImmutableBinaryTree<>('B',
                        new ImmutableBinaryTree<>('D', null, null),
                        new ImmutableBinaryTree<>('E',
                                new ImmutableBinaryTree<>('G', null, null),
                                null
                        )
                ),
                new ImmutableBinaryTree<>('C',
                        null,
                        new ImmutableBinaryTree<>('F', null, null)
                )
        );
        System.out.println(tree);

        System.out.println("Size: " + tree.size());
        System.out.println("Height: " + tree.height());
        System.out.println("Number of Leaves: " + tree.numLeaves());

        System.out.print("\nPre-order Traversal: ");
        Iterator<Character> it = tree.preorderIterator();
        while (it.hasNext()) {
            System.out.print(it.next() + " ");
        }

        System.out.print("\nIn-order Traversal: ");
        for (Character c : tree) {
            System.out.print(c + " ");
        }

        System.out.print("\nPost-order Traversal: ");
        it = tree.postorderIterator();
        while (it.hasNext()) {
            System.out.print(it.next() + " ");
        }
    }
}
