package cs2110;

/**
 * An ordered collection of elements of type `T` that follows the FIFO order condition.
 */
public interface Queue<T> {

    /**
     * Adds `elem` at the "back" of this queue. Requires that `elem != null`.
     */
    void enqueue(T elem);

    /**
     * Removes and returns the "front" element of this queue. Requires `!this.isEmpty()`.
     */
    T dequeue();

    /**
     * Returns the "front" element of this queue without removing it. Requires `!this.isEmpty()`.
     */
    T peek();

    /**
     * Returns `true` if there are currently no elements stored in this queue, otherwise returns
     * `false`.
     */
    boolean isEmpty();
}
